/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.TierBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParseException;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.Utils;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.Any;
import dev.gigaherz.jsonthings.util.parse.value.ArrayValue;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.Lazy;
import org.apache.commons.lang3.mutable.MutableObject;

public class TierParser
extends ThingParser<TierBuilder> {
    public TierParser() {
        super(GSON, "item_tier");
    }

    @Override
    protected void finishLoadingInternal() {
        TierParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> TierSortingRegistry.registerTier((Tier)((Tier)thing.get()), (ResourceLocation)thing.getRegistryName(), thing.getSortAfter(), thing.getSortBefore()), BaseBuilder::getRegistryName);
    }

    @Override
    public TierBuilder processThing(ResourceLocation key, JsonObject data, Consumer<TierBuilder> builderModification) {
        TierBuilder builder = TierBuilder.begin(this, key);
        JParse.begin(data).key("uses", val -> val.intValue().min(1).handle(builder::setUses)).key("speed", val -> val.floatValue().min(1.0f).handle(builder::setSpeed)).key("attack_damage_bonus", val -> val.floatValue().min(1.0f).handle(builder::setAttackDamageBonus)).key("enchantment_value", val -> val.intValue().min(1).handle(builder::setEnchantmentValue)).key("tag", val -> val.string().map(Utils::blockTag).handle(builder::setTag)).key("repair_ingredient", val -> val.map(TierParser::parseMiniIngredient).handle(builder::setRepairIngredient)).key("sort_after", val -> val.array().mapWhole(TierParser::parseDependencyList).handle(builder::setAfterDependencies)).key("sort_before", val -> val.array().mapWhole(TierParser::parseDependencyList).handle(builder::setBeforeDependencies));
        builderModification.accept(builder);
        return builder;
    }

    public static Supplier<Ingredient> parseMiniIngredient(Any any) {
        MutableObject out = new MutableObject();
        any.obj().noKey("type", () -> new ThingParseException("Custom ingredients not supported yet. Please use an 'item' or 'tag' ingredient.")).mutex(List.of("item", "tag"), () -> new ThingParseException("Cannot have both 'tag' and 'item' in the ingredient at the same time.")).ifKey("tag", val -> val.string().map(Utils::itemTag).handle(tag -> out.setValue((Object)Lazy.of(() -> Ingredient.m_204132_((TagKey)tag))))).ifKey("item", val -> val.string().map(ResourceLocation::new).handle(item -> out.setValue((Object)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Utils.getItemOrCrash(item)})))));
        return Objects.requireNonNull((Supplier)out.getValue(), "Invalid state, parsing should never return null here.");
    }

    private static List<Object> parseDependencyList(ArrayValue array) {
        return array.flatMap(entries -> entries.map(e -> e.string().getAsString()).toList());
    }
}

